<?php include 'assets/inc/header.php'; ?>

<div class="newLojista">
	<div class="banner">
		<div class="contaniner-master">
			<div class="blcTitulo">
				<h1>Venha ser um<br><span>Lojista</span></h1>
				<img src="https://qa-uploads.madnezz.com.br/178f5af11d824da1cca3e4939b4f9904" alt="Logo Partage">
			</div>
			<p>
				Seja lojista no Partage e aproveite um ambiente seguro, moderno e cheio de oportunidades para crescer e
				atrair mais clientes!
			</p>

			<a href="#queroSerLojista" class="btnVermelhoTransparente">Quero ser Lojista</a>
		</div>
	</div>
	<div class="mouse"></div>

	<div class="vantagens">
		<div class="contaniner-master">
			<h2>Aqui você terá <span>vantagens!</span></h2>

			<div class="blcVantagens">
				<div class="blc">
					<img src="https://qa-uploads.madnezz.com.br/784525a9223ae8073957a581b19e6ba4" alt="">
					<p>Os shoppings do Partage atraem milhares de visitantes diariamente, aumentando as chances de
						venda.</p>
				</div>

				<div class="blc">
					<img src="https://qa-uploads.madnezz.com.br/bf1baf6fbf77e5d97209a06e409ccc49" alt="">
					<p>Espaços climatizados, segurança, estacionamento e limpeza. Tudo isso aqui no Partage.</p>
				</div>

				<div class="blc">
					<img src="https://qa-uploads.madnezz.com.br/c1737f8141a0ba168a2f07ebecea5e73" alt="">
					<p>Presença em shopping valoriza a marca e transmite confiança ao consumidor.</p>
				</div>

				<div class="blc">
					<img src="https://qa-uploads.madnezz.com.br/050695e068fa2aa00dba5f1d2472b892" alt="">
					<p>Campanhas promocionais do shopping beneficiam todos os lojistas.</p>
				</div>
			</div>

			<a href="#queroSerLojista" class="btnVermelhoTransparente">Quero conhecer as vantagens</a>
		</div>
	</div>




	<div class="fazerParte">
		<div class="contaniner-master">
			<h2>Venha <span>fazer parte</span> do Partage!<br><img
					src="https://qa-uploads.madnezz.com.br/178f5af11d824da1cca3e4939b4f9904" alt="Logo Partage"
					id="queroSerLojista"></h2>

			<!-- <form id="form_comercializacao">
				<input class="form-control" type="text" name="nome" placeholder="Nome *" />
				<input class="form-control" type="text" name="sobrenome" placeholder="Sobrenome *" />
				<input class="form-control" type="text" name="email" placeholder="E-mail *" />
				<input class="form-control" type="text" name="telefone" placeholder="Telefone *" />
				<textarea class="form-control" name="consideracoes_finais" placeholder="Mensagem..."></textarea>

				<div id="recaptcha" class="g-recaptcha" data-sitekey="<?= $recaptcha ?>"></div>


				<button id="btn-validate" class="btn btn-primary btn-hover-secondary btn-width-180 btn-height-60" type="submit">Enviar</button>
			</form> -->

			<?php
			// Mapeamento dos hosts para as siglas SULTS
			$sults_shoppings = [
				// host => sigla
				'3americas' => 'S3A',
				'arapiraca' => 'PSAR',
				'betim' => 'PSBE',
				'boulevardcampos' => 'PSCA',
				'boulevard' => 'PSCA',
				'campos' => 'PSCA',
				'campinagrande' => 'PSCG',
				'partageshoppingcampina' => 'PSCG',
				'jaragua' => 'PSJS',
				'maraba' => 'PSMA',
				'mossoro' => 'PSMO',
				'norte' => 'PNSN',
				'parauapebas' => 'PSPA',
				'pocosdecaldas' => 'PSPC',
				'pocos' => 'PSPC',
				'riogrande' => 'PSRG',
				'partagesantana' => 'PSSA',
				'partageshoppingsantana' => 'PSSA',
				'santanaparqueshopping' => 'PSSA',
				'saogoncalo' => 'PSSG',
				'brasilia' => 'PSBSB',
				'meusite.test' => 'PSAR',
			];


			$host = $_SERVER['HTTP_HOST'] ?? '';
			$sults_sigla = null;


			foreach ($sults_shoppings as $key => $sigla) {
				if (stripos($host, $key) !== false) {
					$sults_sigla = $sigla;
					break;
				}
			}


			if ($sults_sigla):
				?>
				<div class="container">
					<iframe id="sults-lp-iframe" frameborder="0" style="min-height: 900px;width: 100%;"></iframe>
				</div>
				<script src="https://landingpage.sults.com.br/partagemalls/utm-script.js"></script>
				<script>
					let atributos = {
						url: 'https://landingpage.sults.com.br/partagemalls?sigla=<?= $sults_sigla ?>',
						utmSourceAttrName: 'utm_source',
						utmMediumAttrName: 'utm_medium',
						utmCampaignAttrName: 'utm_campaign',
						utmTermAttrName: 'utm_term',
						utmContentAttrName: 'utm_content'
					};
					setTimeout(() => {
						getUTMTags(atributos);
					}, 1000);
				</script>
			<?php endif; ?>


			<img src="https://qa-uploads.madnezz.com.br/d7e1e70e83f644e0ed79178e64977d0b" class="rapazPartage"
				alt="Foto Contato Partage">
		</div>
	</div>
</div>



<style>
	@import url('https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap');

	html,
	body {
		overflow-x: hidden;
	}

	header {
		position: fixed;
		width: 100%;
	}

	header.headerfixed .header-content-desktop {
		height: 65px;
	}

	.btnVermelhoTransparente {
		width: 100%;
		display: block;
		max-width: 520px;
		border: 1px solid #A11C16;
		background-color: transparent;
		border-radius: 50px;
		text-align: center;
		text-decoration: none;
		font-family: 'Poppins', sans-serif;
		color: #A11C16;
		font-size: 29px;
		font-weight: 500;
		padding: 5px 0;
		margin-top: 70px;
		transition: ease .5s all;
	}

	.btnVermelhoTransparente:hover {
		background-color: #A11C16;
		color: #fff;
	}

	.newLojista h2 {
		font-family: 'Poppins', sans-serif;
		font-weight: 400;
		font-size: 56px;
		color: #2b2b2b;
		text-align: center;
	}

	.newLojista h2 span {
		font-family: 'Poppins', sans-serif;
		font-weight: 700;
		font-size: 56px;
		color: #A11C16;
		line-height: 57px;
	}

	.newLojista {
		margin-top: 100px;
	}

	.newLojista .banner {
		min-height: calc(100vh - 153px);
		background-repeat: no-repeat;
		background-position: right center;
		display: flex;
		align-items: center;
		background-image: url('https://qa-uploads.madnezz.com.br/564e27042d7f55d36c64c11197ad303b');
	}

	.newLojista .banner .contaniner-master {
		margin: -50px auto 0;
	}

	.newLojista .banner .blcTitulo {
		max-width: 520px;
		width: 100%;
		display: flex;
		justify-content: space-between;
		align-items: center;
	}

	.newLojista .banner h1 {
		font-family: 'Poppins', sans-serif;
		font-weight: 400;
		font-size: 48px;
		color: #4D5357;
		width: fit-content;
	}

	.newLojista .banner h1 span {
		font-family: 'Poppins', sans-serif;
		font-weight: bold;
		font-size: 82px;
		text-transform: uppercase;
		color: #A11C16;
		line-height: 57px;
	}

	.newLojista .banner p {
		font-family: 'Poppins', sans-serif;
		font-weight: 400;
		font-size: 16px;
		line-height: 24px;
		color: #4D5357;
		max-width: 520px;
		width: 100%;
	}

	.newLojista .mouse {
		width: 35px;
		height: 60px;
		border: 4px solid #333;
		border-radius: 60px;
		justify-self: anchor-center;
		margin-top: -80px;
		position: absolute;
	}

	.newLojista .mouse::before {
		content: '';
		width: 12px;
		height: 12px;
		margin-top: -10px;
		position: absolute;
		top: 10px;
		left: 50%;
		transform: translateX(-50%);
		background-color: #333;
		border-radius: 50%;
		opacity: 1;
		animation: wheel 2s infinite;
		-webkit-animation: wheel 2s infinite;
	}

	@keyframes wheel {
		to {
			opacity: 0;
			top: 60px;
		}
	}

	@-webkit-keyframes wheel {
		to {
			opacity: 0;
			top: 60px;
		}
	}

	.newLojista .vantagens {
		padding: 130px 0;
	}

	.newLojista .vantagens .contaniner-master {
		justify-items: anchor-center;
	}

	.newLojista .vantagens p {
		font-family: 'Poppins', sans-serif;
		font-weight: 400;
		font-size: 16px;
		line-height: 24px;
		color: #4D5357;
		max-width: 286px;
		text-align: center;
	}

	.newLojista .vantagens .blcVantagens {
		display: flex;
		flex-wrap: wrap;
		justify-content: space-around;
		align-items: center;
		width: 100%;
	}

	.newLojista .vantagens .blcVantagens .blc {
		text-align: center;
	}

	.newLojista .vantagens a {
		font-size: 20px;
		max-width: 385px;
		padding: 12.5px 0;
	}

	.newLojista .fazerParte {
		text-align: -webkit-center;
	}

	.newLojista .fazerParte h2 img {
		width: 105px;
	}



	.newLojista .fazerParte #sults-lp-iframe {
		width: 100%;
		max-width: 676px;
		padding: 40px 30px;
		border-radius: 20px;
		background-color: #F5F5F5;
		display: flex;
		flex-wrap: wrap;
		justify-content: space-between;
		box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
		font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
	}

	.newLojista .fazerParte form input {
		width: calc(50% - 12px);
		height: 43px;
		margin-bottom: 24px;
		border-radius: 16px;
		border: none;
		padding: 0 20px;
	}

	.newLojista .fazerParte form textarea {
		width: 100%;
		height: 151px;
		margin-bottom: 24px;
		border-radius: 16px;
		border: none;
		padding: 20px;
		resize: none;
	}

	.newLojista .fazerParte form #recaptcha {
		width: 100%;
	}

	.newLojista .fazerParte form button {
		margin: 23px auto 0;
		width: 100%;
		max-width: 195px;
		height: 43px;
		background: transparent;
		border-radius: 15px;
		border: 2px #fff solid;
		color: #fff;
		font-family: 'Poppins', sans-serif;
		font-weight: 700;
		font-size: 16px;
		cursor: pointer;
		transition: ease .5s all;
	}

	.newLojista .fazerParte form button:hover {
		background-color: #fff;
		color: #A11C16;
	}

	.newLojista .fazerParte .rapazPartage {
		margin: -550px -1030px 0 0;
	}

	@media screen and (max-width:1199px) {
		.newLojista .mouse {
			background: #ffffff80;
		}

		.btnVermelhoTransparente {
			background: #ffffff80;
		}

		.newLojista .banner p {
			background: #ffffffab;
			padding: 15px 0px 15px 6px;
			border-radius: 10px;
			margin: 0;
		}

		.newLojista .banner h1 {
			text-shadow: 0px 0px 6px #ffffffd4;
			color: #000;
		}

		.newLojista .banner img {
			filter: drop-shadow(0px 0px 6px #fff);
		}

		.newLojista {
			margin-top: 84px;
		}

		.newLojista .banner {
			min-height: calc(100vh - 84px);
		}

		.newLojista .fazerParte .rapazPartage {
			display: none;
		}

		.newLojista .fazerParte {
			margin-bottom: 80px;
		}
	}

	@media screen and (max-width:991px) {
		.newLojista .banner {
			align-items: flex-end;
		}

		.newLojista .banner .contaniner-master {
			margin: 0px auto 70px;
		}

		.newLojista .mouse {
			width: 25px;
			height: 50px;
			border: 2px solid #333;
			margin-top: -60px;
		}

		.newLojista .mouse::before {
			width: 6px;
			height: 6px;
		}

		.btnVermelhoTransparente {
			margin-top: 30px;
		}
	}

	@media screen and (max-width:767px) {
		.newLojista .vantagens {
			padding: 0px 0;
		}

		.newLojista .fazerParte #sults-lp-iframe {
			display: table-cell;
			max-width: 80%;
		}

		.newLojista .fazerParte form input {
			margin: 0 4px 24px;
		}
	}

	@media screen and (max-width:520px) {
		.newLojista .banner .blcTitulo {
			flex-direction: column-reverse;
		}

		.newLojista .banner h1 {
			margin-top: 0;
		}

		.newLojista .banner h1 span {
			font-size: 71px;
		}

		.newLojista .banner h1 {
			font-size: 38px;
		}

		.newLojista {
			margin-top: 0px;
		}

		header {
			position: sticky;
		}

		.newLojista .banner {
			background-position: -560px center;
		}

		.newLojista .fazerParte form input {
			margin: 0 0px 24px;
			width: 100%;
		}
	}

	@media screen and (max-width:410px) {
		.newLojista .fazerParte form #recaptcha {
			margin-left: -110px;
		}
	}
</style>

<?php include 'assets/inc/footer.php'; ?>

<script>
	$(function ($) {
		$.mask.definitions["t"] = '[0-9]';
		$('[name="telefone"]').mask("(99) tttt-tttt?t");

		function validaEmail(email) {
			var re = /^(([^<>()[\]\\.,;:\s@\"]+(\.[^<>()[\]\\.,;:\s@\"]+)*)|(\".+\"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
			return re.test(email);
		}

		$(document).on('submit', '#form_comercializacao', function () {
			var nome = $("[name=nome]").val().trim();
			var sobrenome = $("[name=sobrenome]").val().trim();
			var email = $("[name=email]").val().trim();
			var telefone = $("[name=telefone]").val();
			var mensagem = $("[name=consideracoes_finais]").val().trim();

			var recaptchaResponse = grecaptcha.getResponse();

			if (!recaptchaResponse) {
				alert("Preencha o reCaptcha");
				return false;
			} else if (!validaEmail(email)) {
				alert('Preencha um e-mail válido');
				return false;
			} else if (!nome) {
				alert('Preencha o nome corretamente');
				return false;
			} else if (!sobrenome) {
				alert('Preencha o sobrenome corretamente');
				return false;
			} else if (mensagem.length <= 20) {
				alert('Preencha a mensagem corretamente. Mínimo 20 caracteres');
				return false;
			} else if (!telefone) {
				alert('Preencha o campo telefone corretamente');
				return false;
			} else {
				$("#form_comercializacao button").attr("disabled", true);

				$.ajax(apis.comercial, {
					data: {
						"shopping_id": shopping.id,
						"tk": shopping_token,
						"nome": nome,
						"g-recaptcha-response": recaptchaResponse,
						"sobrenome": sobrenome,
						"email": email,
						"telefone": telefone,
						"celular": "",
						"area_de_interesse": "",
						"mix_proposto": "",
						"capacidade_de_investimento": "",
						"area_pretendida": "",
						"ja_possui_loja": "",
						"em_qual_local": "",
						"tempo_de_atuacao": "",
						"numero_de_operacoes": "",
						"consideracoes_finais": mensagem,
						"cpf": "",
						"nascimento": "",
						"endereco": "",
						"endereco_comercial": "",
						"cidade": "",
						"uf": "",
						"tipo": "",
						"rg": "",
						"cancel": "",
						"sendmail": 1
					},
					type: 'POST',
					dataType: 'json'
				}).then(function (data) {
					switch (data.message) {
						case "Comercial cadastrado com sucesso":
							$("[name=nome]").val('');
							$("[name=sobrenome]").val('');
							$("[name=email]").val('');
							$("[name=telefone]").val('');
							$("[name=consideracoes_finais]").val('');

							alert("Mensagem enviada com sucesso");

							$("#form_comercializacao button").attr("disabled", false);
							break;
						default:
							alert("Mensagem não foi enviada. Tente novamente mais tarde.");
							$(".enviar_form").attr("disabled", false);
							break;
					}
				});
			}
			return false;
		});

		$('a[href*="#"]').not('[href="#"]').not('[href="#0"]').click(function (event) {
			// Verifica se é um link interno
			if (location.pathname.replace(/^\//, '') === this.pathname.replace(/^\//, '') &&
				location.hostname === this.hostname) {

				// Obtém o elemento alvo
				var hash = this.hash;
				var target = $(hash);
				if (target.length) {
					event.preventDefault();

					// Calcula a posição de rolagem considerando o header fixo (se houver)
					var headerHeight = $('header').outerHeight() || 0;
					var targetPosition = target.offset().top - headerHeight;

					// Usa a API nativa de rolagem suave
					window.scrollTo({
						top: targetPosition,
						behavior: 'smooth'
					});

					// Atualiza o hash na URL sem causar salto
					history.pushState(null, null, hash);

					// Foco no elemento para acessibilidade
					setTimeout(function () {
						target.attr('tabindex', '-1');
						target.focus();
					}, 1000);
				}
			}
		});
	});
</script>